/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeBean;
import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeTasklet;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Update;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateStyle;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class ChangeConsConfigSpecificTasklet
extends AnalyzeConsoleIntCodeTasklet {
    private static final String TRACE_MASKT = "XMCLCCST";
    private static final String TRACE_MASKF = "XMCLCCSF";
    private static final String TRACE_MASKD = "XMCLCCSD";
    private static final String HELP_PANEL_ID = "@AnalyzeConsoleIntCodePanel";
    private static final String HELP_PROPERTIES = "HELPSET:basehelp.hs;HELPID:com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes.SelectConfigSpecificPanel";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "ChangeConsConfigSpecificTasklet");

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ChangeConsConfigSpecificTasklet.service()");
        try {
            if (request.isInitialRequest()) {
                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.configspecific.busy.text"));
                Trace.trace(TRACE_MASKT, " [ChangeConsConfigSpecificTasklet.service()] Running Analyze Console subclass for config specific changes.");
                this.theUpdateManager = UpdateManager.getUpdateManager();
                this.allUpdatesList = this.theUpdateManager.getTowerUpdates();
                ListIterator iterator = this.allUpdatesList.listIterator();
                while (iterator.hasNext()) {
                    Update update = (Update)iterator.next();
                    if (update.isConfigurationSpecific()) continue;
                    iterator.remove();
                }
                List styles = this.theUpdateManager.getUpdateStylesUsedByUpdate(this.allUpdatesList);
                Trace.trace(TRACE_MASKD, " [AnalyzeConsoleIntCodeTasklet.service()] There are " + Integer.toString(styles.size()) + " styles associated with the list of updates.");
                if (styles.size() > 0) {
                    this.updateStyle = (UpdateStyle)styles.get(0);
                }
                this.refreshLocalUpdateData(null);
                AnalyzeConsoleIntCodeBean bean = new AnalyzeConsoleIntCodeBean();
                bean.refreshData(this.getResponseData());
                bean.setChangeConsoleSubtaskletStatus(true);
                Properties helpProperties = new Properties();
                helpProperties.put(HELP_PANEL_ID, HELP_PROPERTIES);
                this.destroyBusyDialog();
                this.currentPanel = this.AnalyzeConsoleIntCodePanelHandler;
                response.replace("com.ibm.hwmca.base.updates.res.AnalyzeConsoleIntCodeRes", "AnalyzeConsoleIntCodePanel", bean, null, helpProperties, null, null, null);
            } else {
                this.currentPanel.service(request, response);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, " [ChangeConsConfigSpecificTasklet.service()] caught exception: " + e);
            e.printStackTrace();
            new FrameworkLog(classLogInfo, -223, e).log();
            Trace.trace(TRACE_MASKT, " [ChangeConsConfigSpecificTasklet.service()] Terminate task due to unrecoverable error.");
            response.terminate();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsConfigSpecificTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsConfigSpecificTasklet.logException()");
        Trace.trace(TRACE_MASKT, "   processing exception: " + throwable);
        new FrameworkLog(classLogInfo, -224, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ChangeConsConfigSpecificTasklet.logException()");
    }
}

